/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.TimecodeBurninPosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimecodeBurnin
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimecodeBurnin> {
    private static final SdkField<Integer> FONT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TimecodeBurnin.getter(TimecodeBurnin::fontSize)).setter(TimecodeBurnin.setter(Builder::fontSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontSize").build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TimecodeBurnin.getter(TimecodeBurnin::positionAsString)).setter(TimecodeBurnin.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TimecodeBurnin.getter(TimecodeBurnin::prefix)).setter(TimecodeBurnin.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_SIZE_FIELD, POSITION_FIELD, PREFIX_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer fontSize;
    private final String position;
    private final String prefix;

    private TimecodeBurnin(BuilderImpl builder) {
        this.fontSize = builder.fontSize;
        this.position = builder.position;
        this.prefix = builder.prefix;
    }

    public Integer fontSize() {
        return this.fontSize;
    }

    public TimecodeBurninPosition position() {
        return TimecodeBurninPosition.fromValue(this.position);
    }

    public String positionAsString() {
        return this.position;
    }

    public String prefix() {
        return this.prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fontSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.positionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimecodeBurnin)) {
            return false;
        }
        TimecodeBurnin other = (TimecodeBurnin)obj;
        return Objects.equals(this.fontSize(), other.fontSize()) && Objects.equals(this.positionAsString(), other.positionAsString()) && Objects.equals(this.prefix(), other.prefix());
    }

    public String toString() {
        return ToString.builder((String)"TimecodeBurnin").add("FontSize", (Object)this.fontSize()).add("Position", (Object)this.positionAsString()).add("Prefix", (Object)this.prefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FontSize": {
                return Optional.ofNullable(clazz.cast(this.fontSize()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.positionAsString()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimecodeBurnin, T> g) {
        return obj -> g.apply((TimecodeBurnin)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fontSize;
        private String position;
        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(TimecodeBurnin model) {
            this.fontSize(model.fontSize);
            this.position(model.position);
            this.prefix(model.prefix);
        }

        public final Integer getFontSize() {
            return this.fontSize;
        }

        @Override
        public final Builder fontSize(Integer fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public final void setFontSize(Integer fontSize) {
            this.fontSize = fontSize;
        }

        public final String getPosition() {
            return this.position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(TimecodeBurninPosition position) {
            this.position(position.toString());
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public TimecodeBurnin build() {
            return new TimecodeBurnin(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimecodeBurnin> {
        public Builder fontSize(Integer var1);

        public Builder position(String var1);

        public Builder position(TimecodeBurninPosition var1);

        public Builder prefix(String var1);
    }
}

