/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CaptionSourceType {
    ANCILLARY("ANCILLARY"),
    DVB_SUB("DVB_SUB"),
    EMBEDDED("EMBEDDED"),
    SCTE20("SCTE20"),
    SCC("SCC"),
    TTML("TTML"),
    STL("STL"),
    SRT("SRT"),
    SMI("SMI"),
    TELETEXT("TELETEXT"),
    NULL_SOURCE("NULL_SOURCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CaptionSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CaptionSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CaptionSourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CaptionSourceType> knownValues() {
        return Stream.of(CaptionSourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

