/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.VideoDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VideoDescriptionMarshaller {
    private static final MarshallingInfo<String> AFDSIGNALING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("afdSignaling").isBinary(false).build();
    private static final MarshallingInfo<String> ANTIALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("antiAlias").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CODECSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecSettings").isBinary(false).build();
    private static final MarshallingInfo<String> COLORMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorMetadata").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CROP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("crop").isBinary(false).build();
    private static final MarshallingInfo<String> DROPFRAMETIMECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dropFrameTimecode").isBinary(false).build();
    private static final MarshallingInfo<Integer> FIXEDAFD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fixedAfd").isBinary(false).build();
    private static final MarshallingInfo<Integer> HEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("height").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> POSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("position").isBinary(false).build();
    private static final MarshallingInfo<String> RESPONDTOAFD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("respondToAfd").isBinary(false).build();
    private static final MarshallingInfo<String> SCALINGBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scalingBehavior").isBinary(false).build();
    private static final MarshallingInfo<Integer> SHARPNESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sharpness").isBinary(false).build();
    private static final MarshallingInfo<String> TIMECODEINSERTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timecodeInsertion").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VIDEOPREPROCESSORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoPreprocessors").isBinary(false).build();
    private static final MarshallingInfo<Integer> WIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("width").isBinary(false).build();
    private static final VideoDescriptionMarshaller INSTANCE = new VideoDescriptionMarshaller();

    private VideoDescriptionMarshaller() {
    }

    public static VideoDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VideoDescription videoDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)videoDescription, (String)"videoDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)videoDescription.afdSignalingString(), AFDSIGNALING_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.antiAliasString(), ANTIALIAS_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.codecSettings(), CODECSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.colorMetadataString(), COLORMETADATA_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.crop(), CROP_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.dropFrameTimecodeString(), DROPFRAMETIMECODE_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.fixedAfd(), FIXEDAFD_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.height(), HEIGHT_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.position(), POSITION_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.respondToAfdString(), RESPONDTOAFD_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.scalingBehaviorString(), SCALINGBEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.sharpness(), SHARPNESS_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.timecodeInsertionString(), TIMECODEINSERTION_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.videoPreprocessors(), VIDEOPREPROCESSORS_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.width(), WIDTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

