/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.InputClipping;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputClippingMarshaller {
    private static final MarshallingInfo<String> ENDTIMECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTimecode").isBinary(false).build();
    private static final MarshallingInfo<String> STARTTIMECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTimecode").isBinary(false).build();
    private static final InputClippingMarshaller INSTANCE = new InputClippingMarshaller();

    private InputClippingMarshaller() {
    }

    public static InputClippingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputClipping inputClipping, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputClipping, (String)"inputClipping");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputClipping.endTimecode(), ENDTIMECODE_BINDING);
            protocolMarshaller.marshall((Object)inputClipping.startTimecode(), STARTTIMECODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

