/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.DvbSubSourceSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DvbSubSourceSettingsMarshaller {
    private static final MarshallingInfo<Integer> PID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pid").isBinary(false).build();
    private static final DvbSubSourceSettingsMarshaller INSTANCE = new DvbSubSourceSettingsMarshaller();

    private DvbSubSourceSettingsMarshaller() {
    }

    public static DvbSubSourceSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DvbSubSourceSettings dvbSubSourceSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dvbSubSourceSettings, (String)"dvbSubSourceSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dvbSubSourceSettings.pid(), PID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

