/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.AudioSelectorGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AudioSelectorGroupMarshaller {
    private static final MarshallingInfo<List> AUDIOSELECTORNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioSelectorNames").isBinary(false).build();
    private static final AudioSelectorGroupMarshaller INSTANCE = new AudioSelectorGroupMarshaller();

    private AudioSelectorGroupMarshaller() {
    }

    public static AudioSelectorGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioSelectorGroup audioSelectorGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)audioSelectorGroup, (String)"audioSelectorGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(audioSelectorGroup.audioSelectorNames(), AUDIOSELECTORNAMES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

