/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.Mp4CslgAtom;
import software.amazon.awssdk.services.mediaconvert.model.Mp4FreeSpaceBox;
import software.amazon.awssdk.services.mediaconvert.model.Mp4MoovPlacement;
import software.amazon.awssdk.services.mediaconvert.transform.Mp4SettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Mp4Settings
implements StructuredPojo,
ToCopyableBuilder<Builder, Mp4Settings> {
    private final String cslgAtom;
    private final String freeSpaceBox;
    private final String moovPlacement;
    private final String mp4MajorBrand;

    private Mp4Settings(BuilderImpl builder) {
        this.cslgAtom = builder.cslgAtom;
        this.freeSpaceBox = builder.freeSpaceBox;
        this.moovPlacement = builder.moovPlacement;
        this.mp4MajorBrand = builder.mp4MajorBrand;
    }

    public Mp4CslgAtom cslgAtom() {
        return Mp4CslgAtom.fromValue(this.cslgAtom);
    }

    public String cslgAtomString() {
        return this.cslgAtom;
    }

    public Mp4FreeSpaceBox freeSpaceBox() {
        return Mp4FreeSpaceBox.fromValue(this.freeSpaceBox);
    }

    public String freeSpaceBoxString() {
        return this.freeSpaceBox;
    }

    public Mp4MoovPlacement moovPlacement() {
        return Mp4MoovPlacement.fromValue(this.moovPlacement);
    }

    public String moovPlacementString() {
        return this.moovPlacement;
    }

    public String mp4MajorBrand() {
        return this.mp4MajorBrand;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cslgAtomString());
        hashCode = 31 * hashCode + Objects.hashCode(this.freeSpaceBoxString());
        hashCode = 31 * hashCode + Objects.hashCode(this.moovPlacementString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mp4MajorBrand());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mp4Settings)) {
            return false;
        }
        Mp4Settings other = (Mp4Settings)obj;
        return Objects.equals(this.cslgAtomString(), other.cslgAtomString()) && Objects.equals(this.freeSpaceBoxString(), other.freeSpaceBoxString()) && Objects.equals(this.moovPlacementString(), other.moovPlacementString()) && Objects.equals(this.mp4MajorBrand(), other.mp4MajorBrand());
    }

    public String toString() {
        return ToString.builder((String)"Mp4Settings").add("CslgAtom", (Object)this.cslgAtomString()).add("FreeSpaceBox", (Object)this.freeSpaceBoxString()).add("MoovPlacement", (Object)this.moovPlacementString()).add("Mp4MajorBrand", (Object)this.mp4MajorBrand()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CslgAtom": {
                return Optional.of(clazz.cast(this.cslgAtomString()));
            }
            case "FreeSpaceBox": {
                return Optional.of(clazz.cast(this.freeSpaceBoxString()));
            }
            case "MoovPlacement": {
                return Optional.of(clazz.cast(this.moovPlacementString()));
            }
            case "Mp4MajorBrand": {
                return Optional.of(clazz.cast(this.mp4MajorBrand()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Mp4SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String cslgAtom;
        private String freeSpaceBox;
        private String moovPlacement;
        private String mp4MajorBrand;

        private BuilderImpl() {
        }

        private BuilderImpl(Mp4Settings model) {
            this.cslgAtom(model.cslgAtom);
            this.freeSpaceBox(model.freeSpaceBox);
            this.moovPlacement(model.moovPlacement);
            this.mp4MajorBrand(model.mp4MajorBrand);
        }

        public final String getCslgAtom() {
            return this.cslgAtom;
        }

        @Override
        public final Builder cslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
            return this;
        }

        @Override
        public final Builder cslgAtom(Mp4CslgAtom cslgAtom) {
            this.cslgAtom(cslgAtom.toString());
            return this;
        }

        public final void setCslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
        }

        public final String getFreeSpaceBox() {
            return this.freeSpaceBox;
        }

        @Override
        public final Builder freeSpaceBox(String freeSpaceBox) {
            this.freeSpaceBox = freeSpaceBox;
            return this;
        }

        @Override
        public final Builder freeSpaceBox(Mp4FreeSpaceBox freeSpaceBox) {
            this.freeSpaceBox(freeSpaceBox.toString());
            return this;
        }

        public final void setFreeSpaceBox(String freeSpaceBox) {
            this.freeSpaceBox = freeSpaceBox;
        }

        public final String getMoovPlacement() {
            return this.moovPlacement;
        }

        @Override
        public final Builder moovPlacement(String moovPlacement) {
            this.moovPlacement = moovPlacement;
            return this;
        }

        @Override
        public final Builder moovPlacement(Mp4MoovPlacement moovPlacement) {
            this.moovPlacement(moovPlacement.toString());
            return this;
        }

        public final void setMoovPlacement(String moovPlacement) {
            this.moovPlacement = moovPlacement;
        }

        public final String getMp4MajorBrand() {
            return this.mp4MajorBrand;
        }

        @Override
        public final Builder mp4MajorBrand(String mp4MajorBrand) {
            this.mp4MajorBrand = mp4MajorBrand;
            return this;
        }

        public final void setMp4MajorBrand(String mp4MajorBrand) {
            this.mp4MajorBrand = mp4MajorBrand;
        }

        public Mp4Settings build() {
            return new Mp4Settings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Mp4Settings> {
        public Builder cslgAtom(String var1);

        public Builder cslgAtom(Mp4CslgAtom var1);

        public Builder freeSpaceBox(String var1);

        public Builder freeSpaceBox(Mp4FreeSpaceBox var1);

        public Builder moovPlacement(String var1);

        public Builder moovPlacement(Mp4MoovPlacement var1);

        public Builder mp4MajorBrand(String var1);
    }
}

