/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.mediaconvert.model.ListOfPresetCopier;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertResponse;
import software.amazon.awssdk.services.mediaconvert.model.Preset;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPresetsResponse
extends MediaConvertResponse
implements ToCopyableBuilder<Builder, ListPresetsResponse> {
    private final String nextToken;
    private final List<Preset> presets;

    private ListPresetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.presets = builder.presets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<Preset> presets() {
        return this.presets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.presets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPresetsResponse)) {
            return false;
        }
        ListPresetsResponse other = (ListPresetsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.presets(), other.presets());
    }

    public String toString() {
        return ToString.builder((String)"ListPresetsResponse").add("NextToken", (Object)this.nextToken()).add("Presets", this.presets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "Presets": {
                return Optional.of(clazz.cast(this.presets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaConvertResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Preset> presets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPresetsResponse model) {
            this.nextToken(model.nextToken);
            this.presets(model.presets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Preset.Builder> getPresets() {
            return this.presets != null ? (Collection)this.presets.stream().map(Preset::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder presets(Collection<Preset> presets) {
            this.presets = ListOfPresetCopier.copy(presets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder presets(Preset ... presets) {
            this.presets(Arrays.asList(presets));
            return this;
        }

        public final void setPresets(Collection<Preset.BuilderImpl> presets) {
            this.presets = ListOfPresetCopier.copyFromBuilder(presets);
        }

        @Override
        public ListPresetsResponse build() {
            return new ListPresetsResponse(this);
        }
    }

    public static interface Builder
    extends MediaConvertResponse.Builder,
    CopyableBuilder<Builder, ListPresetsResponse> {
        public Builder nextToken(String var1);

        public Builder presets(Collection<Preset> var1);

        public Builder presets(Preset ... var1);
    }
}

