/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.ColorSpaceConversion;
import software.amazon.awssdk.services.mediaconvert.model.Hdr10Metadata;
import software.amazon.awssdk.services.mediaconvert.transform.ColorCorrectorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ColorCorrector
implements StructuredPojo,
ToCopyableBuilder<Builder, ColorCorrector> {
    private final Integer brightness;
    private final String colorSpaceConversion;
    private final Integer contrast;
    private final Hdr10Metadata hdr10Metadata;
    private final Integer hue;
    private final Integer saturation;

    private ColorCorrector(BuilderImpl builder) {
        this.brightness = builder.brightness;
        this.colorSpaceConversion = builder.colorSpaceConversion;
        this.contrast = builder.contrast;
        this.hdr10Metadata = builder.hdr10Metadata;
        this.hue = builder.hue;
        this.saturation = builder.saturation;
    }

    public Integer brightness() {
        return this.brightness;
    }

    public ColorSpaceConversion colorSpaceConversion() {
        return ColorSpaceConversion.fromValue(this.colorSpaceConversion);
    }

    public String colorSpaceConversionString() {
        return this.colorSpaceConversion;
    }

    public Integer contrast() {
        return this.contrast;
    }

    public Hdr10Metadata hdr10Metadata() {
        return this.hdr10Metadata;
    }

    public Integer hue() {
        return this.hue;
    }

    public Integer saturation() {
        return this.saturation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brightness());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceConversionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contrast());
        hashCode = 31 * hashCode + Objects.hashCode(this.hdr10Metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hue());
        hashCode = 31 * hashCode + Objects.hashCode(this.saturation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorCorrector)) {
            return false;
        }
        ColorCorrector other = (ColorCorrector)obj;
        return Objects.equals(this.brightness(), other.brightness()) && Objects.equals(this.colorSpaceConversionString(), other.colorSpaceConversionString()) && Objects.equals(this.contrast(), other.contrast()) && Objects.equals(this.hdr10Metadata(), other.hdr10Metadata()) && Objects.equals(this.hue(), other.hue()) && Objects.equals(this.saturation(), other.saturation());
    }

    public String toString() {
        return ToString.builder((String)"ColorCorrector").add("Brightness", (Object)this.brightness()).add("ColorSpaceConversion", (Object)this.colorSpaceConversionString()).add("Contrast", (Object)this.contrast()).add("Hdr10Metadata", (Object)this.hdr10Metadata()).add("Hue", (Object)this.hue()).add("Saturation", (Object)this.saturation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Brightness": {
                return Optional.of(clazz.cast(this.brightness()));
            }
            case "ColorSpaceConversion": {
                return Optional.of(clazz.cast(this.colorSpaceConversionString()));
            }
            case "Contrast": {
                return Optional.of(clazz.cast(this.contrast()));
            }
            case "Hdr10Metadata": {
                return Optional.of(clazz.cast(this.hdr10Metadata()));
            }
            case "Hue": {
                return Optional.of(clazz.cast(this.hue()));
            }
            case "Saturation": {
                return Optional.of(clazz.cast(this.saturation()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ColorCorrectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer brightness;
        private String colorSpaceConversion;
        private Integer contrast;
        private Hdr10Metadata hdr10Metadata;
        private Integer hue;
        private Integer saturation;

        private BuilderImpl() {
        }

        private BuilderImpl(ColorCorrector model) {
            this.brightness(model.brightness);
            this.colorSpaceConversion(model.colorSpaceConversion);
            this.contrast(model.contrast);
            this.hdr10Metadata(model.hdr10Metadata);
            this.hue(model.hue);
            this.saturation(model.saturation);
        }

        public final Integer getBrightness() {
            return this.brightness;
        }

        @Override
        public final Builder brightness(Integer brightness) {
            this.brightness = brightness;
            return this;
        }

        public final void setBrightness(Integer brightness) {
            this.brightness = brightness;
        }

        public final String getColorSpaceConversion() {
            return this.colorSpaceConversion;
        }

        @Override
        public final Builder colorSpaceConversion(String colorSpaceConversion) {
            this.colorSpaceConversion = colorSpaceConversion;
            return this;
        }

        @Override
        public final Builder colorSpaceConversion(ColorSpaceConversion colorSpaceConversion) {
            this.colorSpaceConversion(colorSpaceConversion.toString());
            return this;
        }

        public final void setColorSpaceConversion(String colorSpaceConversion) {
            this.colorSpaceConversion = colorSpaceConversion;
        }

        public final Integer getContrast() {
            return this.contrast;
        }

        @Override
        public final Builder contrast(Integer contrast) {
            this.contrast = contrast;
            return this;
        }

        public final void setContrast(Integer contrast) {
            this.contrast = contrast;
        }

        public final Hdr10Metadata.Builder getHdr10Metadata() {
            return this.hdr10Metadata != null ? this.hdr10Metadata.toBuilder() : null;
        }

        @Override
        public final Builder hdr10Metadata(Hdr10Metadata hdr10Metadata) {
            this.hdr10Metadata = hdr10Metadata;
            return this;
        }

        public final void setHdr10Metadata(Hdr10Metadata.BuilderImpl hdr10Metadata) {
            this.hdr10Metadata = hdr10Metadata != null ? hdr10Metadata.build() : null;
        }

        public final Integer getHue() {
            return this.hue;
        }

        @Override
        public final Builder hue(Integer hue) {
            this.hue = hue;
            return this;
        }

        public final void setHue(Integer hue) {
            this.hue = hue;
        }

        public final Integer getSaturation() {
            return this.saturation;
        }

        @Override
        public final Builder saturation(Integer saturation) {
            this.saturation = saturation;
            return this;
        }

        public final void setSaturation(Integer saturation) {
            this.saturation = saturation;
        }

        public ColorCorrector build() {
            return new ColorCorrector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ColorCorrector> {
        public Builder brightness(Integer var1);

        public Builder colorSpaceConversion(String var1);

        public Builder colorSpaceConversion(ColorSpaceConversion var1);

        public Builder contrast(Integer var1);

        public Builder hdr10Metadata(Hdr10Metadata var1);

        default public Builder hdr10Metadata(Consumer<Hdr10Metadata.Builder> hdr10Metadata) {
            return this.hdr10Metadata((Hdr10Metadata)((Hdr10Metadata.Builder)Hdr10Metadata.builder().apply(hdr10Metadata)).build());
        }

        public Builder hue(Integer var1);

        public Builder saturation(Integer var1);
    }
}

