/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.VideoPreprocessor;

@SdkInternalApi
public class VideoPreprocessorMarshaller {
    private static final MarshallingInfo<StructuredPojo> COLORCORRECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorCorrector").build();
    private static final MarshallingInfo<StructuredPojo> DEINTERLACER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deinterlacer").build();
    private static final MarshallingInfo<StructuredPojo> IMAGEINSERTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageInserter").build();
    private static final MarshallingInfo<StructuredPojo> NOISEREDUCER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("noiseReducer").build();
    private static final MarshallingInfo<StructuredPojo> TIMECODEBURNIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timecodeBurnin").build();
    private static final VideoPreprocessorMarshaller INSTANCE = new VideoPreprocessorMarshaller();

    public static VideoPreprocessorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VideoPreprocessor videoPreprocessor, ProtocolMarshaller protocolMarshaller) {
        if (videoPreprocessor == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)videoPreprocessor.colorCorrector(), COLORCORRECTOR_BINDING);
            protocolMarshaller.marshall((Object)videoPreprocessor.deinterlacer(), DEINTERLACER_BINDING);
            protocolMarshaller.marshall((Object)videoPreprocessor.imageInserter(), IMAGEINSERTER_BINDING);
            protocolMarshaller.marshall((Object)videoPreprocessor.noiseReducer(), NOISEREDUCER_BINDING);
            protocolMarshaller.marshall((Object)videoPreprocessor.timecodeBurnin(), TIMECODEBURNIN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

