/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.SpekeKeyProvider;

@SdkInternalApi
public class SpekeKeyProviderMarshaller {
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").build();
    private static final MarshallingInfo<List> SYSTEMIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("systemIds").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").build();
    private static final SpekeKeyProviderMarshaller INSTANCE = new SpekeKeyProviderMarshaller();

    public static SpekeKeyProviderMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SpekeKeyProvider spekeKeyProvider, ProtocolMarshaller protocolMarshaller) {
        if (spekeKeyProvider == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)spekeKeyProvider.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(spekeKeyProvider.systemIds(), SYSTEMIDS_BINDING);
            protocolMarshaller.marshall((Object)spekeKeyProvider.url(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

