/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2Settings;

@SdkInternalApi
public class Mpeg2SettingsMarshaller {
    private static final MarshallingInfo<String> ADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adaptiveQuantization").build();
    private static final MarshallingInfo<Integer> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").build();
    private static final MarshallingInfo<String> CODECLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecLevel").build();
    private static final MarshallingInfo<String> CODECPROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecProfile").build();
    private static final MarshallingInfo<String> FRAMERATECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateControl").build();
    private static final MarshallingInfo<String> FRAMERATECONVERSIONALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateConversionAlgorithm").build();
    private static final MarshallingInfo<Integer> FRAMERATEDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateDenominator").build();
    private static final MarshallingInfo<Integer> FRAMERATENUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateNumerator").build();
    private static final MarshallingInfo<Integer> GOPCLOSEDCADENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopClosedCadence").build();
    private static final MarshallingInfo<Double> GOPSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopSize").build();
    private static final MarshallingInfo<String> GOPSIZEUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopSizeUnits").build();
    private static final MarshallingInfo<Integer> HRDBUFFERINITIALFILLPERCENTAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hrdBufferInitialFillPercentage").build();
    private static final MarshallingInfo<Integer> HRDBUFFERSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hrdBufferSize").build();
    private static final MarshallingInfo<String> INTERLACEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interlaceMode").build();
    private static final MarshallingInfo<String> INTRADCPRECISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("intraDcPrecision").build();
    private static final MarshallingInfo<Integer> MAXBITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxBitrate").build();
    private static final MarshallingInfo<Integer> MINIINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minIInterval").build();
    private static final MarshallingInfo<Integer> NUMBERBFRAMESBETWEENREFERENCEFRAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberBFramesBetweenReferenceFrames").build();
    private static final MarshallingInfo<String> PARCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parControl").build();
    private static final MarshallingInfo<Integer> PARDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parDenominator").build();
    private static final MarshallingInfo<Integer> PARNUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parNumerator").build();
    private static final MarshallingInfo<String> QUALITYTUNINGLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("qualityTuningLevel").build();
    private static final MarshallingInfo<String> RATECONTROLMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateControlMode").build();
    private static final MarshallingInfo<String> SCENECHANGEDETECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sceneChangeDetect").build();
    private static final MarshallingInfo<String> SLOWPAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slowPal").build();
    private static final MarshallingInfo<Integer> SOFTNESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("softness").build();
    private static final MarshallingInfo<String> SPATIALADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spatialAdaptiveQuantization").build();
    private static final MarshallingInfo<String> SYNTAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("syntax").build();
    private static final MarshallingInfo<String> TELECINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("telecine").build();
    private static final MarshallingInfo<String> TEMPORALADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("temporalAdaptiveQuantization").build();
    private static final Mpeg2SettingsMarshaller INSTANCE = new Mpeg2SettingsMarshaller();

    public static Mpeg2SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Mpeg2Settings mpeg2Settings, ProtocolMarshaller protocolMarshaller) {
        if (mpeg2Settings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mpeg2Settings.adaptiveQuantizationString(), ADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.codecLevelString(), CODECLEVEL_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.codecProfileString(), CODECPROFILE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.framerateControlString(), FRAMERATECONTROL_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.framerateConversionAlgorithmString(), FRAMERATECONVERSIONALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.framerateDenominator(), FRAMERATEDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.framerateNumerator(), FRAMERATENUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.gopClosedCadence(), GOPCLOSEDCADENCE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.gopSize(), GOPSIZE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.gopSizeUnitsString(), GOPSIZEUNITS_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.hrdBufferInitialFillPercentage(), HRDBUFFERINITIALFILLPERCENTAGE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.hrdBufferSize(), HRDBUFFERSIZE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.interlaceModeString(), INTERLACEMODE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.intraDcPrecisionString(), INTRADCPRECISION_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.maxBitrate(), MAXBITRATE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.minIInterval(), MINIINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.numberBFramesBetweenReferenceFrames(), NUMBERBFRAMESBETWEENREFERENCEFRAMES_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.parControlString(), PARCONTROL_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.parDenominator(), PARDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.parNumerator(), PARNUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.qualityTuningLevelString(), QUALITYTUNINGLEVEL_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.rateControlModeString(), RATECONTROLMODE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.sceneChangeDetectString(), SCENECHANGEDETECT_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.slowPalString(), SLOWPAL_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.softness(), SOFTNESS_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.spatialAdaptiveQuantizationString(), SPATIALADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.syntaxString(), SYNTAX_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.telecineString(), TELECINE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.temporalAdaptiveQuantizationString(), TEMPORALADAPTIVEQUANTIZATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

