/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Mp2Settings;

@SdkInternalApi
public class Mp2SettingsMarshaller {
    private static final MarshallingInfo<Integer> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").build();
    private static final MarshallingInfo<Integer> CHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channels").build();
    private static final MarshallingInfo<Integer> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").build();
    private static final Mp2SettingsMarshaller INSTANCE = new Mp2SettingsMarshaller();

    public static Mp2SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Mp2Settings mp2Settings, ProtocolMarshaller protocolMarshaller) {
        if (mp2Settings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mp2Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)mp2Settings.channels(), CHANNELS_BINDING);
            protocolMarshaller.marshall((Object)mp2Settings.sampleRate(), SAMPLERATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

