/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.InputTemplate;

@SdkInternalApi
public class InputTemplateMarshaller {
    private static final MarshallingInfo<Map> AUDIOSELECTORGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioSelectorGroups").build();
    private static final MarshallingInfo<Map> AUDIOSELECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioSelectors").build();
    private static final MarshallingInfo<Map> CAPTIONSELECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionSelectors").build();
    private static final MarshallingInfo<String> DEBLOCKFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deblockFilter").build();
    private static final MarshallingInfo<String> DENOISEFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("denoiseFilter").build();
    private static final MarshallingInfo<String> FILTERENABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filterEnable").build();
    private static final MarshallingInfo<Integer> FILTERSTRENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filterStrength").build();
    private static final MarshallingInfo<List> INPUTCLIPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputClippings").build();
    private static final MarshallingInfo<Integer> PROGRAMNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("programNumber").build();
    private static final MarshallingInfo<String> PSICONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("psiControl").build();
    private static final MarshallingInfo<String> TIMECODESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timecodeSource").build();
    private static final MarshallingInfo<StructuredPojo> VIDEOSELECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoSelector").build();
    private static final InputTemplateMarshaller INSTANCE = new InputTemplateMarshaller();

    public static InputTemplateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputTemplate inputTemplate, ProtocolMarshaller protocolMarshaller) {
        if (inputTemplate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(inputTemplate.audioSelectorGroups(), AUDIOSELECTORGROUPS_BINDING);
            protocolMarshaller.marshall(inputTemplate.audioSelectors(), AUDIOSELECTORS_BINDING);
            protocolMarshaller.marshall(inputTemplate.captionSelectors(), CAPTIONSELECTORS_BINDING);
            protocolMarshaller.marshall((Object)inputTemplate.deblockFilterString(), DEBLOCKFILTER_BINDING);
            protocolMarshaller.marshall((Object)inputTemplate.denoiseFilterString(), DENOISEFILTER_BINDING);
            protocolMarshaller.marshall((Object)inputTemplate.filterEnableString(), FILTERENABLE_BINDING);
            protocolMarshaller.marshall((Object)inputTemplate.filterStrength(), FILTERSTRENGTH_BINDING);
            protocolMarshaller.marshall(inputTemplate.inputClippings(), INPUTCLIPPINGS_BINDING);
            protocolMarshaller.marshall((Object)inputTemplate.programNumber(), PROGRAMNUMBER_BINDING);
            protocolMarshaller.marshall((Object)inputTemplate.psiControlString(), PSICONTROL_BINDING);
            protocolMarshaller.marshall((Object)inputTemplate.timecodeSourceString(), TIMECODESOURCE_BINDING);
            protocolMarshaller.marshall((Object)inputTemplate.videoSelector(), VIDEOSELECTOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

