/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.HlsSettings;

@SdkInternalApi
public class HlsSettingsMarshaller {
    private static final MarshallingInfo<String> AUDIOGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioGroupId").build();
    private static final MarshallingInfo<String> AUDIORENDITIONSETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioRenditionSets").build();
    private static final MarshallingInfo<String> AUDIOTRACKTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioTrackType").build();
    private static final MarshallingInfo<String> IFRAMEONLYMANIFEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iFrameOnlyManifest").build();
    private static final MarshallingInfo<String> SEGMENTMODIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentModifier").build();
    private static final HlsSettingsMarshaller INSTANCE = new HlsSettingsMarshaller();

    public static HlsSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsSettings hlsSettings, ProtocolMarshaller protocolMarshaller) {
        if (hlsSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hlsSettings.audioGroupId(), AUDIOGROUPID_BINDING);
            protocolMarshaller.marshall((Object)hlsSettings.audioRenditionSets(), AUDIORENDITIONSETS_BINDING);
            protocolMarshaller.marshall((Object)hlsSettings.audioTrackTypeString(), AUDIOTRACKTYPE_BINDING);
            protocolMarshaller.marshall((Object)hlsSettings.iFrameOnlyManifestString(), IFRAMEONLYMANIFEST_BINDING);
            protocolMarshaller.marshall((Object)hlsSettings.segmentModifier(), SEGMENTMODIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

