/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.HlsEncryptionSettings;

@SdkInternalApi
public class HlsEncryptionSettingsMarshaller {
    private static final MarshallingInfo<String> CONSTANTINITIALIZATIONVECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("constantInitializationVector").build();
    private static final MarshallingInfo<String> ENCRYPTIONMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionMethod").build();
    private static final MarshallingInfo<String> INITIALIZATIONVECTORINMANIFEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("initializationVectorInManifest").build();
    private static final MarshallingInfo<StructuredPojo> SPEKEKEYPROVIDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spekeKeyProvider").build();
    private static final MarshallingInfo<StructuredPojo> STATICKEYPROVIDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("staticKeyProvider").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final HlsEncryptionSettingsMarshaller INSTANCE = new HlsEncryptionSettingsMarshaller();

    public static HlsEncryptionSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsEncryptionSettings hlsEncryptionSettings, ProtocolMarshaller protocolMarshaller) {
        if (hlsEncryptionSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hlsEncryptionSettings.constantInitializationVector(), CONSTANTINITIALIZATIONVECTOR_BINDING);
            protocolMarshaller.marshall((Object)hlsEncryptionSettings.encryptionMethodString(), ENCRYPTIONMETHOD_BINDING);
            protocolMarshaller.marshall((Object)hlsEncryptionSettings.initializationVectorInManifestString(), INITIALIZATIONVECTORINMANIFEST_BINDING);
            protocolMarshaller.marshall((Object)hlsEncryptionSettings.spekeKeyProvider(), SPEKEKEYPROVIDER_BINDING);
            protocolMarshaller.marshall((Object)hlsEncryptionSettings.staticKeyProvider(), STATICKEYPROVIDER_BINDING);
            protocolMarshaller.marshall((Object)hlsEncryptionSettings.typeString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

