/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Hdr10Metadata;

@SdkInternalApi
public class Hdr10MetadataMarshaller {
    private static final MarshallingInfo<Integer> BLUEPRIMARYX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bluePrimaryX").build();
    private static final MarshallingInfo<Integer> BLUEPRIMARYY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bluePrimaryY").build();
    private static final MarshallingInfo<Integer> GREENPRIMARYX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("greenPrimaryX").build();
    private static final MarshallingInfo<Integer> GREENPRIMARYY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("greenPrimaryY").build();
    private static final MarshallingInfo<Integer> MAXCONTENTLIGHTLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxContentLightLevel").build();
    private static final MarshallingInfo<Integer> MAXFRAMEAVERAGELIGHTLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxFrameAverageLightLevel").build();
    private static final MarshallingInfo<Integer> MAXLUMINANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxLuminance").build();
    private static final MarshallingInfo<Integer> MINLUMINANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minLuminance").build();
    private static final MarshallingInfo<Integer> REDPRIMARYX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("redPrimaryX").build();
    private static final MarshallingInfo<Integer> REDPRIMARYY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("redPrimaryY").build();
    private static final MarshallingInfo<Integer> WHITEPOINTX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("whitePointX").build();
    private static final MarshallingInfo<Integer> WHITEPOINTY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("whitePointY").build();
    private static final Hdr10MetadataMarshaller INSTANCE = new Hdr10MetadataMarshaller();

    public static Hdr10MetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Hdr10Metadata hdr10Metadata, ProtocolMarshaller protocolMarshaller) {
        if (hdr10Metadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hdr10Metadata.bluePrimaryX(), BLUEPRIMARYX_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.bluePrimaryY(), BLUEPRIMARYY_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.greenPrimaryX(), GREENPRIMARYX_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.greenPrimaryY(), GREENPRIMARYY_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.maxContentLightLevel(), MAXCONTENTLIGHTLEVEL_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.maxFrameAverageLightLevel(), MAXFRAMEAVERAGELIGHTLEVEL_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.maxLuminance(), MAXLUMINANCE_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.minLuminance(), MINLUMINANCE_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.redPrimaryX(), REDPRIMARYX_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.redPrimaryY(), REDPRIMARYY_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.whitePointX(), WHITEPOINTX_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.whitePointY(), WHITEPOINTY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

