/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.ContainerSettings;

@SdkInternalApi
public class ContainerSettingsMarshaller {
    private static final MarshallingInfo<String> CONTAINER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("container").build();
    private static final MarshallingInfo<StructuredPojo> F4VSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("f4vSettings").build();
    private static final MarshallingInfo<StructuredPojo> M2TSSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("m2tsSettings").build();
    private static final MarshallingInfo<StructuredPojo> M3U8SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("m3u8Settings").build();
    private static final MarshallingInfo<StructuredPojo> MOVSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("movSettings").build();
    private static final MarshallingInfo<StructuredPojo> MP4SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mp4Settings").build();
    private static final ContainerSettingsMarshaller INSTANCE = new ContainerSettingsMarshaller();

    public static ContainerSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ContainerSettings containerSettings, ProtocolMarshaller protocolMarshaller) {
        if (containerSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)containerSettings.containerString(), CONTAINER_BINDING);
            protocolMarshaller.marshall((Object)containerSettings.f4vSettings(), F4VSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)containerSettings.m2tsSettings(), M2TSSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)containerSettings.m3u8Settings(), M3U8SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)containerSettings.movSettings(), MOVSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)containerSettings.mp4Settings(), MP4SETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

