/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.ColorCorrector;

@SdkInternalApi
public class ColorCorrectorMarshaller {
    private static final MarshallingInfo<Integer> BRIGHTNESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brightness").build();
    private static final MarshallingInfo<String> COLORSPACECONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorSpaceConversion").build();
    private static final MarshallingInfo<Integer> CONTRAST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contrast").build();
    private static final MarshallingInfo<StructuredPojo> HDR10METADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hdr10Metadata").build();
    private static final MarshallingInfo<Integer> HUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hue").build();
    private static final MarshallingInfo<Integer> SATURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("saturation").build();
    private static final ColorCorrectorMarshaller INSTANCE = new ColorCorrectorMarshaller();

    public static ColorCorrectorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ColorCorrector colorCorrector, ProtocolMarshaller protocolMarshaller) {
        if (colorCorrector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)colorCorrector.brightness(), BRIGHTNESS_BINDING);
            protocolMarshaller.marshall((Object)colorCorrector.colorSpaceConversionString(), COLORSPACECONVERSION_BINDING);
            protocolMarshaller.marshall((Object)colorCorrector.contrast(), CONTRAST_BINDING);
            protocolMarshaller.marshall((Object)colorCorrector.hdr10Metadata(), HDR10METADATA_BINDING);
            protocolMarshaller.marshall((Object)colorCorrector.hue(), HUE_BINDING);
            protocolMarshaller.marshall((Object)colorCorrector.saturation(), SATURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

