/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.CaptionSourceSettings;

@SdkInternalApi
public class CaptionSourceSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> ANCILLARYSOURCESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ancillarySourceSettings").build();
    private static final MarshallingInfo<StructuredPojo> DVBSUBSOURCESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbSubSourceSettings").build();
    private static final MarshallingInfo<StructuredPojo> EMBEDDEDSOURCESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("embeddedSourceSettings").build();
    private static final MarshallingInfo<StructuredPojo> FILESOURCESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileSourceSettings").build();
    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceType").build();
    private static final MarshallingInfo<StructuredPojo> TELETEXTSOURCESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("teletextSourceSettings").build();
    private static final CaptionSourceSettingsMarshaller INSTANCE = new CaptionSourceSettingsMarshaller();

    public static CaptionSourceSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CaptionSourceSettings captionSourceSettings, ProtocolMarshaller protocolMarshaller) {
        if (captionSourceSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)captionSourceSettings.ancillarySourceSettings(), ANCILLARYSOURCESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionSourceSettings.dvbSubSourceSettings(), DVBSUBSOURCESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionSourceSettings.embeddedSourceSettings(), EMBEDDEDSOURCESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionSourceSettings.fileSourceSettings(), FILESOURCESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionSourceSettings.sourceTypeString(), SOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)captionSourceSettings.teletextSourceSettings(), TELETEXTSOURCESETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

