/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.AudioCodecSettings;

@SdkInternalApi
public class AudioCodecSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> AACSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("aacSettings").build();
    private static final MarshallingInfo<StructuredPojo> AC3SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ac3Settings").build();
    private static final MarshallingInfo<StructuredPojo> AIFFSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("aiffSettings").build();
    private static final MarshallingInfo<String> CODEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codec").build();
    private static final MarshallingInfo<StructuredPojo> EAC3SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eac3Settings").build();
    private static final MarshallingInfo<StructuredPojo> MP2SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mp2Settings").build();
    private static final MarshallingInfo<StructuredPojo> WAVSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("wavSettings").build();
    private static final AudioCodecSettingsMarshaller INSTANCE = new AudioCodecSettingsMarshaller();

    public static AudioCodecSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioCodecSettings audioCodecSettings, ProtocolMarshaller protocolMarshaller) {
        if (audioCodecSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)audioCodecSettings.aacSettings(), AACSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioCodecSettings.ac3Settings(), AC3SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioCodecSettings.aiffSettings(), AIFFSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioCodecSettings.codecString(), CODEC_BINDING);
            protocolMarshaller.marshall((Object)audioCodecSettings.eac3Settings(), EAC3SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioCodecSettings.mp2Settings(), MP2SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioCodecSettings.wavSettings(), WAVSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

