/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.InsertableImage;
import software.amazon.awssdk.services.mediaconvert.model.ListOfInsertableImageCopier;
import software.amazon.awssdk.services.mediaconvert.transform.ImageInserterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImageInserter
implements StructuredPojo,
ToCopyableBuilder<Builder, ImageInserter> {
    private final List<InsertableImage> insertableImages;

    private ImageInserter(BuilderImpl builder) {
        this.insertableImages = builder.insertableImages;
    }

    public List<InsertableImage> insertableImages() {
        return this.insertableImages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.insertableImages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageInserter)) {
            return false;
        }
        ImageInserter other = (ImageInserter)obj;
        return Objects.equals(this.insertableImages(), other.insertableImages());
    }

    public String toString() {
        return ToString.builder((String)"ImageInserter").add("InsertableImages", this.insertableImages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsertableImages": {
                return Optional.of(clazz.cast(this.insertableImages()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageInserterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InsertableImage> insertableImages;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageInserter model) {
            this.insertableImages(model.insertableImages);
        }

        public final Collection<InsertableImage.Builder> getInsertableImages() {
            return this.insertableImages != null ? (Collection)this.insertableImages.stream().map(InsertableImage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder insertableImages(Collection<InsertableImage> insertableImages) {
            this.insertableImages = ListOfInsertableImageCopier.copy(insertableImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insertableImages(InsertableImage ... insertableImages) {
            this.insertableImages(Arrays.asList(insertableImages));
            return this;
        }

        public final void setInsertableImages(Collection<InsertableImage.BuilderImpl> insertableImages) {
            this.insertableImages = ListOfInsertableImageCopier.copyFromBuilder(insertableImages);
        }

        public ImageInserter build() {
            return new ImageInserter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageInserter> {
        public Builder insertableImages(Collection<InsertableImage> var1);

        public Builder insertableImages(InsertableImage ... var1);
    }
}

