/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.DeinterlaceAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.DeinterlacerControl;
import software.amazon.awssdk.services.mediaconvert.model.DeinterlacerMode;
import software.amazon.awssdk.services.mediaconvert.transform.DeinterlacerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Deinterlacer
implements StructuredPojo,
ToCopyableBuilder<Builder, Deinterlacer> {
    private final String algorithm;
    private final String control;
    private final String mode;

    private Deinterlacer(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.control = builder.control;
        this.mode = builder.mode;
    }

    public DeinterlaceAlgorithm algorithm() {
        return DeinterlaceAlgorithm.fromValue(this.algorithm);
    }

    public String algorithmString() {
        return this.algorithm;
    }

    public DeinterlacerControl control() {
        return DeinterlacerControl.fromValue(this.control);
    }

    public String controlString() {
        return this.control;
    }

    public DeinterlacerMode mode() {
        return DeinterlacerMode.fromValue(this.mode);
    }

    public String modeString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmString());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deinterlacer)) {
            return false;
        }
        Deinterlacer other = (Deinterlacer)obj;
        return Objects.equals(this.algorithmString(), other.algorithmString()) && Objects.equals(this.controlString(), other.controlString()) && Objects.equals(this.modeString(), other.modeString());
    }

    public String toString() {
        return ToString.builder((String)"Deinterlacer").add("Algorithm", (Object)this.algorithmString()).add("Control", (Object)this.controlString()).add("Mode", (Object)this.modeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.of(clazz.cast(this.algorithmString()));
            }
            case "Control": {
                return Optional.of(clazz.cast(this.controlString()));
            }
            case "Mode": {
                return Optional.of(clazz.cast(this.modeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeinterlacerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private String control;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(Deinterlacer model) {
            this.algorithm(model.algorithm);
            this.control(model.control);
            this.mode(model.mode);
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(DeinterlaceAlgorithm algorithm) {
            this.algorithm(algorithm.toString());
            return this;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public final String getControl() {
            return this.control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        @Override
        public final Builder control(DeinterlacerControl control) {
            this.control(control.toString());
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DeinterlacerMode mode) {
            this.mode(mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public Deinterlacer build() {
            return new Deinterlacer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Deinterlacer> {
        public Builder algorithm(String var1);

        public Builder algorithm(DeinterlaceAlgorithm var1);

        public Builder control(String var1);

        public Builder control(DeinterlacerControl var1);

        public Builder mode(String var1);

        public Builder mode(DeinterlacerMode var1);
    }
}

