/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.VideoCodecSettings;
import software.amazon.awssdk.services.mediaconvert.transform.FrameCaptureSettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.H264SettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.H265SettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.Mpeg2SettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.ProresSettingsUnmarshaller;

public class VideoCodecSettingsUnmarshaller
implements Unmarshaller<VideoCodecSettings, JsonUnmarshallerContext> {
    private static final VideoCodecSettingsUnmarshaller INSTANCE = new VideoCodecSettingsUnmarshaller();

    public VideoCodecSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        VideoCodecSettings.Builder videoCodecSettingsBuilder = VideoCodecSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("codec", targetDepth)) {
                    context.nextToken();
                    videoCodecSettingsBuilder.codec((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("frameCaptureSettings", targetDepth)) {
                    context.nextToken();
                    videoCodecSettingsBuilder.frameCaptureSettings(FrameCaptureSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("h264Settings", targetDepth)) {
                    context.nextToken();
                    videoCodecSettingsBuilder.h264Settings(H264SettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("h265Settings", targetDepth)) {
                    context.nextToken();
                    videoCodecSettingsBuilder.h265Settings(H265SettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("mpeg2Settings", targetDepth)) {
                    context.nextToken();
                    videoCodecSettingsBuilder.mpeg2Settings(Mpeg2SettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("proresSettings", targetDepth)) {
                    context.nextToken();
                    videoCodecSettingsBuilder.proresSettings(ProresSettingsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (VideoCodecSettings)videoCodecSettingsBuilder.build();
    }

    public static VideoCodecSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

