/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Timing;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TimingMarshaller {
    private static final MarshallingInfo<Instant> FINISHTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("finishTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> SUBMITTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("submitTime").isBinary(false).build();
    private static final TimingMarshaller INSTANCE = new TimingMarshaller();

    private TimingMarshaller() {
    }

    public static TimingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Timing timing, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)timing, (String)"timing");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)timing.finishTime(), FINISHTIME_BINDING);
            protocolMarshaller.marshall((Object)timing.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)timing.submitTime(), SUBMITTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

