/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.StaticKeyProvider;

public class StaticKeyProviderUnmarshaller
implements Unmarshaller<StaticKeyProvider, JsonUnmarshallerContext> {
    private static final StaticKeyProviderUnmarshaller INSTANCE = new StaticKeyProviderUnmarshaller();

    public StaticKeyProvider unmarshall(JsonUnmarshallerContext context) throws Exception {
        StaticKeyProvider.Builder staticKeyProviderBuilder = StaticKeyProvider.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("keyFormat", targetDepth)) {
                    context.nextToken();
                    staticKeyProviderBuilder.keyFormat((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("keyFormatVersions", targetDepth)) {
                    context.nextToken();
                    staticKeyProviderBuilder.keyFormatVersions((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("staticKeyValue", targetDepth)) {
                    context.nextToken();
                    staticKeyProviderBuilder.staticKeyValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("url", targetDepth)) {
                    context.nextToken();
                    staticKeyProviderBuilder.url((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (StaticKeyProvider)staticKeyProviderBuilder.build();
    }

    public static StaticKeyProviderUnmarshaller getInstance() {
        return INSTANCE;
    }
}

