/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.ResourceTags;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceTagsMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final ResourceTagsMarshaller INSTANCE = new ResourceTagsMarshaller();

    private ResourceTagsMarshaller() {
    }

    public static ResourceTagsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceTags resourceTags, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceTags, (String)"resourceTags");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceTags.arn(), ARN_BINDING);
            protocolMarshaller.marshall(resourceTags.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

