/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Queue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class QueueMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdated").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<Integer> PROGRESSINGJOBSCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("progressingJobsCount").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<Integer> SUBMITTEDJOBSCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("submittedJobsCount").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final QueueMarshaller INSTANCE = new QueueMarshaller();

    private QueueMarshaller() {
    }

    public static QueueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Queue queue, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)queue, (String)"queue");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)queue.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)queue.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)queue.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)queue.lastUpdated(), LASTUPDATED_BINDING);
            protocolMarshaller.marshall((Object)queue.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)queue.progressingJobsCount(), PROGRESSINGJOBSCOUNT_BINDING);
            protocolMarshaller.marshall((Object)queue.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)queue.submittedJobsCount(), SUBMITTEDJOBSCOUNT_BINDING);
            protocolMarshaller.marshall((Object)queue.typeAsString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

