/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.OutputSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> HLSSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsSettings").isBinary(false).build();
    private static final OutputSettingsMarshaller INSTANCE = new OutputSettingsMarshaller();

    private OutputSettingsMarshaller() {
    }

    public static OutputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputSettings outputSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputSettings, (String)"outputSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outputSettings.hlsSettings(), HLSSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

