/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.OutputGroupDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputGroupDetailMarshaller {
    private static final MarshallingInfo<List> OUTPUTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputDetails").isBinary(false).build();
    private static final OutputGroupDetailMarshaller INSTANCE = new OutputGroupDetailMarshaller();

    private OutputGroupDetailMarshaller() {
    }

    public static OutputGroupDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputGroupDetail outputGroupDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputGroupDetail, (String)"outputGroupDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(outputGroupDetail.outputDetails(), OUTPUTDETAILS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

