/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.NielsenConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NielsenConfigurationMarshaller {
    private static final MarshallingInfo<Integer> BREAKOUTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("breakoutCode").isBinary(false).build();
    private static final MarshallingInfo<String> DISTRIBUTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("distributorId").isBinary(false).build();
    private static final NielsenConfigurationMarshaller INSTANCE = new NielsenConfigurationMarshaller();

    private NielsenConfigurationMarshaller() {
    }

    public static NielsenConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NielsenConfiguration nielsenConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)nielsenConfiguration, (String)"nielsenConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)nielsenConfiguration.breakoutCode(), BREAKOUTCODE_BINDING);
            protocolMarshaller.marshall((Object)nielsenConfiguration.distributorId(), DISTRIBUTORID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

