/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.MsSmoothEncryptionSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MsSmoothEncryptionSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> SPEKEKEYPROVIDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spekeKeyProvider").isBinary(false).build();
    private static final MsSmoothEncryptionSettingsMarshaller INSTANCE = new MsSmoothEncryptionSettingsMarshaller();

    private MsSmoothEncryptionSettingsMarshaller() {
    }

    public static MsSmoothEncryptionSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MsSmoothEncryptionSettings msSmoothEncryptionSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)msSmoothEncryptionSettings, (String)"msSmoothEncryptionSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)msSmoothEncryptionSettings.spekeKeyProvider(), SPEKEKEYPROVIDER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

