/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Mp2Settings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class Mp2SettingsMarshaller {
    private static final MarshallingInfo<Integer> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<Integer> CHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channels").isBinary(false).build();
    private static final MarshallingInfo<Integer> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").isBinary(false).build();
    private static final Mp2SettingsMarshaller INSTANCE = new Mp2SettingsMarshaller();

    private Mp2SettingsMarshaller() {
    }

    public static Mp2SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Mp2Settings mp2Settings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)mp2Settings, (String)"mp2Settings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)mp2Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)mp2Settings.channels(), CHANNELS_BINDING);
            protocolMarshaller.marshall((Object)mp2Settings.sampleRate(), SAMPLERATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

