/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.ImageInserter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImageInserterMarshaller {
    private static final MarshallingInfo<List> INSERTABLEIMAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("insertableImages").isBinary(false).build();
    private static final ImageInserterMarshaller INSTANCE = new ImageInserterMarshaller();

    private ImageInserterMarshaller() {
    }

    public static ImageInserterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImageInserter imageInserter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)imageInserter, (String)"imageInserter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(imageInserter.insertableImages(), INSERTABLEIMAGES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

