/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.HlsGroupSettings;
import software.amazon.awssdk.services.mediaconvert.transform.HlsCaptionLanguageMappingUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.HlsEncryptionSettingsUnmarshaller;

public class HlsGroupSettingsUnmarshaller
implements Unmarshaller<HlsGroupSettings, JsonUnmarshallerContext> {
    private static final HlsGroupSettingsUnmarshaller INSTANCE = new HlsGroupSettingsUnmarshaller();

    public HlsGroupSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        HlsGroupSettings.Builder hlsGroupSettingsBuilder = HlsGroupSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("adMarkers", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.adMarkersWithStrings(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("baseUrl", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.baseUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("captionLanguageMappings", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.captionLanguageMappings(new ListUnmarshaller((Unmarshaller)HlsCaptionLanguageMappingUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("captionLanguageSetting", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.captionLanguageSetting((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("clientCache", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.clientCache((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("codecSpecification", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.codecSpecification((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("destination", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.destination((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("directoryStructure", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.directoryStructure((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("encryption", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.encryption(HlsEncryptionSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("manifestCompression", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.manifestCompression((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("manifestDurationFormat", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.manifestDurationFormat((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("minFinalSegmentLength", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.minFinalSegmentLength((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("minSegmentLength", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.minSegmentLength((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("outputSelection", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.outputSelection((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("programDateTime", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.programDateTime((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("programDateTimePeriod", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.programDateTimePeriod((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("segmentControl", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.segmentControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("segmentLength", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.segmentLength((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("segmentsPerSubdirectory", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.segmentsPerSubdirectory((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("streamInfResolution", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.streamInfResolution((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("timedMetadataId3Frame", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.timedMetadataId3Frame((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("timedMetadataId3Period", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.timedMetadataId3Period((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("timestampDeltaMilliseconds", targetDepth)) {
                    context.nextToken();
                    hlsGroupSettingsBuilder.timestampDeltaMilliseconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (HlsGroupSettings)hlsGroupSettingsBuilder.build();
    }

    public static HlsGroupSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

