/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Hdr10Metadata;

public class Hdr10MetadataUnmarshaller
implements Unmarshaller<Hdr10Metadata, JsonUnmarshallerContext> {
    private static final Hdr10MetadataUnmarshaller INSTANCE = new Hdr10MetadataUnmarshaller();

    public Hdr10Metadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        Hdr10Metadata.Builder hdr10MetadataBuilder = Hdr10Metadata.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bluePrimaryX", targetDepth)) {
                    context.nextToken();
                    hdr10MetadataBuilder.bluePrimaryX((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("bluePrimaryY", targetDepth)) {
                    context.nextToken();
                    hdr10MetadataBuilder.bluePrimaryY((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("greenPrimaryX", targetDepth)) {
                    context.nextToken();
                    hdr10MetadataBuilder.greenPrimaryX((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("greenPrimaryY", targetDepth)) {
                    context.nextToken();
                    hdr10MetadataBuilder.greenPrimaryY((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("maxContentLightLevel", targetDepth)) {
                    context.nextToken();
                    hdr10MetadataBuilder.maxContentLightLevel((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("maxFrameAverageLightLevel", targetDepth)) {
                    context.nextToken();
                    hdr10MetadataBuilder.maxFrameAverageLightLevel((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("maxLuminance", targetDepth)) {
                    context.nextToken();
                    hdr10MetadataBuilder.maxLuminance((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("minLuminance", targetDepth)) {
                    context.nextToken();
                    hdr10MetadataBuilder.minLuminance((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("redPrimaryX", targetDepth)) {
                    context.nextToken();
                    hdr10MetadataBuilder.redPrimaryX((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("redPrimaryY", targetDepth)) {
                    context.nextToken();
                    hdr10MetadataBuilder.redPrimaryY((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("whitePointX", targetDepth)) {
                    context.nextToken();
                    hdr10MetadataBuilder.whitePointX((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("whitePointY", targetDepth)) {
                    context.nextToken();
                    hdr10MetadataBuilder.whitePointY((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Hdr10Metadata)hdr10MetadataBuilder.build();
    }

    public static Hdr10MetadataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

