/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Hdr10Metadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class Hdr10MetadataMarshaller {
    private static final MarshallingInfo<Integer> BLUEPRIMARYX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bluePrimaryX").isBinary(false).build();
    private static final MarshallingInfo<Integer> BLUEPRIMARYY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bluePrimaryY").isBinary(false).build();
    private static final MarshallingInfo<Integer> GREENPRIMARYX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("greenPrimaryX").isBinary(false).build();
    private static final MarshallingInfo<Integer> GREENPRIMARYY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("greenPrimaryY").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXCONTENTLIGHTLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxContentLightLevel").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXFRAMEAVERAGELIGHTLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxFrameAverageLightLevel").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXLUMINANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxLuminance").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINLUMINANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minLuminance").isBinary(false).build();
    private static final MarshallingInfo<Integer> REDPRIMARYX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("redPrimaryX").isBinary(false).build();
    private static final MarshallingInfo<Integer> REDPRIMARYY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("redPrimaryY").isBinary(false).build();
    private static final MarshallingInfo<Integer> WHITEPOINTX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("whitePointX").isBinary(false).build();
    private static final MarshallingInfo<Integer> WHITEPOINTY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("whitePointY").isBinary(false).build();
    private static final Hdr10MetadataMarshaller INSTANCE = new Hdr10MetadataMarshaller();

    private Hdr10MetadataMarshaller() {
    }

    public static Hdr10MetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Hdr10Metadata hdr10Metadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hdr10Metadata, (String)"hdr10Metadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hdr10Metadata.bluePrimaryX(), BLUEPRIMARYX_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.bluePrimaryY(), BLUEPRIMARYY_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.greenPrimaryX(), GREENPRIMARYX_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.greenPrimaryY(), GREENPRIMARYY_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.maxContentLightLevel(), MAXCONTENTLIGHTLEVEL_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.maxFrameAverageLightLevel(), MAXFRAMEAVERAGELIGHTLEVEL_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.maxLuminance(), MAXLUMINANCE_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.minLuminance(), MINLUMINANCE_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.redPrimaryX(), REDPRIMARYX_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.redPrimaryY(), REDPRIMARYY_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.whitePointX(), WHITEPOINTX_BINDING);
            protocolMarshaller.marshall((Object)hdr10Metadata.whitePointY(), WHITEPOINTY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

