/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.H265Settings;
import software.amazon.awssdk.services.mediaconvert.transform.H265QvbrSettingsUnmarshaller;

public class H265SettingsUnmarshaller
implements Unmarshaller<H265Settings, JsonUnmarshallerContext> {
    private static final H265SettingsUnmarshaller INSTANCE = new H265SettingsUnmarshaller();

    public H265Settings unmarshall(JsonUnmarshallerContext context) throws Exception {
        H265Settings.Builder h265SettingsBuilder = H265Settings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("adaptiveQuantization", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.adaptiveQuantization((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("alternateTransferFunctionSei", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.alternateTransferFunctionSei((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("bitrate", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.bitrate((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("codecLevel", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.codecLevel((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("codecProfile", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.codecProfile((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("dynamicSubGop", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.dynamicSubGop((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("flickerAdaptiveQuantization", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.flickerAdaptiveQuantization((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("framerateControl", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.framerateControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("framerateConversionAlgorithm", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.framerateConversionAlgorithm((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("framerateDenominator", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.framerateDenominator((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("framerateNumerator", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.framerateNumerator((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopBReference", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.gopBReference((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopClosedCadence", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.gopClosedCadence((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopSize", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.gopSize((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopSizeUnits", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.gopSizeUnits((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("hrdBufferInitialFillPercentage", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.hrdBufferInitialFillPercentage((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("hrdBufferSize", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.hrdBufferSize((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("interlaceMode", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.interlaceMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("maxBitrate", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.maxBitrate((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("minIInterval", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.minIInterval((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("numberBFramesBetweenReferenceFrames", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.numberBFramesBetweenReferenceFrames((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("numberReferenceFrames", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.numberReferenceFrames((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("parControl", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.parControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("parDenominator", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.parDenominator((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("parNumerator", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.parNumerator((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("qualityTuningLevel", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.qualityTuningLevel((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("qvbrSettings", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.qvbrSettings(H265QvbrSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("rateControlMode", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.rateControlMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("sampleAdaptiveOffsetFilterMode", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.sampleAdaptiveOffsetFilterMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("sceneChangeDetect", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.sceneChangeDetect((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("slices", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.slices((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("slowPal", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.slowPal((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("spatialAdaptiveQuantization", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.spatialAdaptiveQuantization((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("telecine", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.telecine((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("temporalAdaptiveQuantization", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.temporalAdaptiveQuantization((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("temporalIds", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.temporalIds((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("tiles", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.tiles((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("unregisteredSeiTimecode", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.unregisteredSeiTimecode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("writeMp4PackagingType", targetDepth)) {
                    context.nextToken();
                    h265SettingsBuilder.writeMp4PackagingType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (H265Settings)h265SettingsBuilder.build();
    }

    public static H265SettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

