/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.H265Settings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class H265SettingsMarshaller {
    private static final MarshallingInfo<String> ADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adaptiveQuantization").isBinary(false).build();
    private static final MarshallingInfo<String> ALTERNATETRANSFERFUNCTIONSEI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alternateTransferFunctionSei").isBinary(false).build();
    private static final MarshallingInfo<Integer> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<String> CODECLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecLevel").isBinary(false).build();
    private static final MarshallingInfo<String> CODECPROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecProfile").isBinary(false).build();
    private static final MarshallingInfo<String> DYNAMICSUBGOP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamicSubGop").isBinary(false).build();
    private static final MarshallingInfo<String> FLICKERADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("flickerAdaptiveQuantization").isBinary(false).build();
    private static final MarshallingInfo<String> FRAMERATECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateControl").isBinary(false).build();
    private static final MarshallingInfo<String> FRAMERATECONVERSIONALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateConversionAlgorithm").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAMERATEDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateDenominator").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAMERATENUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateNumerator").isBinary(false).build();
    private static final MarshallingInfo<String> GOPBREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopBReference").isBinary(false).build();
    private static final MarshallingInfo<Integer> GOPCLOSEDCADENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopClosedCadence").isBinary(false).build();
    private static final MarshallingInfo<Double> GOPSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopSize").isBinary(false).build();
    private static final MarshallingInfo<String> GOPSIZEUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopSizeUnits").isBinary(false).build();
    private static final MarshallingInfo<Integer> HRDBUFFERINITIALFILLPERCENTAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hrdBufferInitialFillPercentage").isBinary(false).build();
    private static final MarshallingInfo<Integer> HRDBUFFERSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hrdBufferSize").isBinary(false).build();
    private static final MarshallingInfo<String> INTERLACEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interlaceMode").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXBITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxBitrate").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINIINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minIInterval").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBERBFRAMESBETWEENREFERENCEFRAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberBFramesBetweenReferenceFrames").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBERREFERENCEFRAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberReferenceFrames").isBinary(false).build();
    private static final MarshallingInfo<String> PARCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> PARDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parDenominator").isBinary(false).build();
    private static final MarshallingInfo<Integer> PARNUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parNumerator").isBinary(false).build();
    private static final MarshallingInfo<String> QUALITYTUNINGLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("qualityTuningLevel").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> QVBRSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("qvbrSettings").isBinary(false).build();
    private static final MarshallingInfo<String> RATECONTROLMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateControlMode").isBinary(false).build();
    private static final MarshallingInfo<String> SAMPLEADAPTIVEOFFSETFILTERMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleAdaptiveOffsetFilterMode").isBinary(false).build();
    private static final MarshallingInfo<String> SCENECHANGEDETECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sceneChangeDetect").isBinary(false).build();
    private static final MarshallingInfo<Integer> SLICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slices").isBinary(false).build();
    private static final MarshallingInfo<String> SLOWPAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slowPal").isBinary(false).build();
    private static final MarshallingInfo<String> SPATIALADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spatialAdaptiveQuantization").isBinary(false).build();
    private static final MarshallingInfo<String> TELECINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("telecine").isBinary(false).build();
    private static final MarshallingInfo<String> TEMPORALADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("temporalAdaptiveQuantization").isBinary(false).build();
    private static final MarshallingInfo<String> TEMPORALIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("temporalIds").isBinary(false).build();
    private static final MarshallingInfo<String> TILES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tiles").isBinary(false).build();
    private static final MarshallingInfo<String> UNREGISTEREDSEITIMECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unregisteredSeiTimecode").isBinary(false).build();
    private static final MarshallingInfo<String> WRITEMP4PACKAGINGTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("writeMp4PackagingType").isBinary(false).build();
    private static final H265SettingsMarshaller INSTANCE = new H265SettingsMarshaller();

    private H265SettingsMarshaller() {
    }

    public static H265SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(H265Settings h265Settings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)h265Settings, (String)"h265Settings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)h265Settings.adaptiveQuantizationAsString(), ADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.alternateTransferFunctionSeiAsString(), ALTERNATETRANSFERFUNCTIONSEI_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.codecLevelAsString(), CODECLEVEL_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.codecProfileAsString(), CODECPROFILE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.dynamicSubGopAsString(), DYNAMICSUBGOP_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.flickerAdaptiveQuantizationAsString(), FLICKERADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.framerateControlAsString(), FRAMERATECONTROL_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.framerateConversionAlgorithmAsString(), FRAMERATECONVERSIONALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.framerateDenominator(), FRAMERATEDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.framerateNumerator(), FRAMERATENUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.gopBReferenceAsString(), GOPBREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.gopClosedCadence(), GOPCLOSEDCADENCE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.gopSize(), GOPSIZE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.gopSizeUnitsAsString(), GOPSIZEUNITS_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.hrdBufferInitialFillPercentage(), HRDBUFFERINITIALFILLPERCENTAGE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.hrdBufferSize(), HRDBUFFERSIZE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.interlaceModeAsString(), INTERLACEMODE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.maxBitrate(), MAXBITRATE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.minIInterval(), MINIINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.numberBFramesBetweenReferenceFrames(), NUMBERBFRAMESBETWEENREFERENCEFRAMES_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.numberReferenceFrames(), NUMBERREFERENCEFRAMES_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.parControlAsString(), PARCONTROL_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.parDenominator(), PARDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.parNumerator(), PARNUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.qualityTuningLevelAsString(), QUALITYTUNINGLEVEL_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.qvbrSettings(), QVBRSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.rateControlModeAsString(), RATECONTROLMODE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.sampleAdaptiveOffsetFilterModeAsString(), SAMPLEADAPTIVEOFFSETFILTERMODE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.sceneChangeDetectAsString(), SCENECHANGEDETECT_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.slices(), SLICES_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.slowPalAsString(), SLOWPAL_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.spatialAdaptiveQuantizationAsString(), SPATIALADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.telecineAsString(), TELECINE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.temporalAdaptiveQuantizationAsString(), TEMPORALADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.temporalIdsAsString(), TEMPORALIDS_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.tilesAsString(), TILES_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.unregisteredSeiTimecodeAsString(), UNREGISTEREDSEITIMECODE_BINDING);
            protocolMarshaller.marshall((Object)h265Settings.writeMp4PackagingTypeAsString(), WRITEMP4PACKAGINGTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

