/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.FileGroupSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FileGroupSettingsMarshaller {
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").isBinary(false).build();
    private static final FileGroupSettingsMarshaller INSTANCE = new FileGroupSettingsMarshaller();

    private FileGroupSettingsMarshaller() {
    }

    public static FileGroupSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FileGroupSettings fileGroupSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)fileGroupSettings, (String)"fileGroupSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)fileGroupSettings.destination(), DESTINATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

