/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoEncryptionSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DashIsoEncryptionSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> SPEKEKEYPROVIDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spekeKeyProvider").isBinary(false).build();
    private static final DashIsoEncryptionSettingsMarshaller INSTANCE = new DashIsoEncryptionSettingsMarshaller();

    private DashIsoEncryptionSettingsMarshaller() {
    }

    public static DashIsoEncryptionSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DashIsoEncryptionSettings dashIsoEncryptionSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dashIsoEncryptionSettings, (String)"dashIsoEncryptionSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dashIsoEncryptionSettings.spekeKeyProvider(), SPEKEKEYPROVIDER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

