/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.ContainerSettings;
import software.amazon.awssdk.services.mediaconvert.transform.F4vSettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.M2tsSettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.M3u8SettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.MovSettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.Mp4SettingsUnmarshaller;

public class ContainerSettingsUnmarshaller
implements Unmarshaller<ContainerSettings, JsonUnmarshallerContext> {
    private static final ContainerSettingsUnmarshaller INSTANCE = new ContainerSettingsUnmarshaller();

    public ContainerSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        ContainerSettings.Builder containerSettingsBuilder = ContainerSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("container", targetDepth)) {
                    context.nextToken();
                    containerSettingsBuilder.container((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("f4vSettings", targetDepth)) {
                    context.nextToken();
                    containerSettingsBuilder.f4vSettings(F4vSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("m2tsSettings", targetDepth)) {
                    context.nextToken();
                    containerSettingsBuilder.m2tsSettings(M2tsSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("m3u8Settings", targetDepth)) {
                    context.nextToken();
                    containerSettingsBuilder.m3u8Settings(M3u8SettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("movSettings", targetDepth)) {
                    context.nextToken();
                    containerSettingsBuilder.movSettings(MovSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("mp4Settings", targetDepth)) {
                    context.nextToken();
                    containerSettingsBuilder.mp4Settings(Mp4SettingsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ContainerSettings)containerSettingsBuilder.build();
    }

    public static ContainerSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

