/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.CmafGroupSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CmafGroupSettingsMarshaller {
    private static final MarshallingInfo<String> BASEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("baseUrl").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTCACHE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientCache").isBinary(false).build();
    private static final MarshallingInfo<String> CODECSPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecSpecification").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryption").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAGMENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fragmentLength").isBinary(false).build();
    private static final MarshallingInfo<String> MANIFESTCOMPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestCompression").isBinary(false).build();
    private static final MarshallingInfo<String> MANIFESTDURATIONFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestDurationFormat").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINBUFFERTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minBufferTime").isBinary(false).build();
    private static final MarshallingInfo<Double> MINFINALSEGMENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minFinalSegmentLength").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> SEGMENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentLength").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMINFRESOLUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamInfResolution").isBinary(false).build();
    private static final MarshallingInfo<String> WRITEDASHMANIFEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("writeDashManifest").isBinary(false).build();
    private static final MarshallingInfo<String> WRITEHLSMANIFEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("writeHlsManifest").isBinary(false).build();
    private static final CmafGroupSettingsMarshaller INSTANCE = new CmafGroupSettingsMarshaller();

    private CmafGroupSettingsMarshaller() {
    }

    public static CmafGroupSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CmafGroupSettings cmafGroupSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cmafGroupSettings, (String)"cmafGroupSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cmafGroupSettings.baseUrl(), BASEURL_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.clientCacheAsString(), CLIENTCACHE_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.codecSpecificationAsString(), CODECSPECIFICATION_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.encryption(), ENCRYPTION_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.fragmentLength(), FRAGMENTLENGTH_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.manifestCompressionAsString(), MANIFESTCOMPRESSION_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.manifestDurationFormatAsString(), MANIFESTDURATIONFORMAT_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.minBufferTime(), MINBUFFERTIME_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.minFinalSegmentLength(), MINFINALSEGMENTLENGTH_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.segmentControlAsString(), SEGMENTCONTROL_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.segmentLength(), SEGMENTLENGTH_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.streamInfResolutionAsString(), STREAMINFRESOLUTION_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.writeDashManifestAsString(), WRITEDASHMANIFEST_BINDING);
            protocolMarshaller.marshall((Object)cmafGroupSettings.writeHlsManifestAsString(), WRITEHLSMANIFEST_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

