/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.CmafEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.transform.StaticKeyProviderUnmarshaller;

public class CmafEncryptionSettingsUnmarshaller
implements Unmarshaller<CmafEncryptionSettings, JsonUnmarshallerContext> {
    private static final CmafEncryptionSettingsUnmarshaller INSTANCE = new CmafEncryptionSettingsUnmarshaller();

    public CmafEncryptionSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        CmafEncryptionSettings.Builder cmafEncryptionSettingsBuilder = CmafEncryptionSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("constantInitializationVector", targetDepth)) {
                    context.nextToken();
                    cmafEncryptionSettingsBuilder.constantInitializationVector((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("encryptionMethod", targetDepth)) {
                    context.nextToken();
                    cmafEncryptionSettingsBuilder.encryptionMethod((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("initializationVectorInManifest", targetDepth)) {
                    context.nextToken();
                    cmafEncryptionSettingsBuilder.initializationVectorInManifest((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("staticKeyProvider", targetDepth)) {
                    context.nextToken();
                    cmafEncryptionSettingsBuilder.staticKeyProvider(StaticKeyProviderUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    cmafEncryptionSettingsBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CmafEncryptionSettings)cmafEncryptionSettingsBuilder.build();
    }

    public static CmafEncryptionSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

