/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.CmafEncryptionSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CmafEncryptionSettingsMarshaller {
    private static final MarshallingInfo<String> CONSTANTINITIALIZATIONVECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("constantInitializationVector").isBinary(false).build();
    private static final MarshallingInfo<String> ENCRYPTIONMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionMethod").isBinary(false).build();
    private static final MarshallingInfo<String> INITIALIZATIONVECTORINMANIFEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("initializationVectorInManifest").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATICKEYPROVIDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("staticKeyProvider").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final CmafEncryptionSettingsMarshaller INSTANCE = new CmafEncryptionSettingsMarshaller();

    private CmafEncryptionSettingsMarshaller() {
    }

    public static CmafEncryptionSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CmafEncryptionSettings cmafEncryptionSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cmafEncryptionSettings, (String)"cmafEncryptionSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cmafEncryptionSettings.constantInitializationVector(), CONSTANTINITIALIZATIONVECTOR_BINDING);
            protocolMarshaller.marshall((Object)cmafEncryptionSettings.encryptionMethodAsString(), ENCRYPTIONMETHOD_BINDING);
            protocolMarshaller.marshall((Object)cmafEncryptionSettings.initializationVectorInManifestAsString(), INITIALIZATIONVECTORINMANIFEST_BINDING);
            protocolMarshaller.marshall((Object)cmafEncryptionSettings.staticKeyProvider(), STATICKEYPROVIDER_BINDING);
            protocolMarshaller.marshall((Object)cmafEncryptionSettings.typeAsString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

