/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.AiffSettings;

public class AiffSettingsUnmarshaller
implements Unmarshaller<AiffSettings, JsonUnmarshallerContext> {
    private static final AiffSettingsUnmarshaller INSTANCE = new AiffSettingsUnmarshaller();

    public AiffSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        AiffSettings.Builder aiffSettingsBuilder = AiffSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bitDepth", targetDepth)) {
                    context.nextToken();
                    aiffSettingsBuilder.bitDepth((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("channels", targetDepth)) {
                    context.nextToken();
                    aiffSettingsBuilder.channels((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("sampleRate", targetDepth)) {
                    context.nextToken();
                    aiffSettingsBuilder.sampleRate((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AiffSettings)aiffSettingsBuilder.build();
    }

    public static AiffSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

