/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.AiffSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AiffSettingsMarshaller {
    private static final MarshallingInfo<Integer> BITDEPTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitDepth").isBinary(false).build();
    private static final MarshallingInfo<Integer> CHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channels").isBinary(false).build();
    private static final MarshallingInfo<Integer> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").isBinary(false).build();
    private static final AiffSettingsMarshaller INSTANCE = new AiffSettingsMarshaller();

    private AiffSettingsMarshaller() {
    }

    public static AiffSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AiffSettings aiffSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)aiffSettings, (String)"aiffSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)aiffSettings.bitDepth(), BITDEPTH_BINDING);
            protocolMarshaller.marshall((Object)aiffSettings.channels(), CHANNELS_BINDING);
            protocolMarshaller.marshall((Object)aiffSettings.sampleRate(), SAMPLERATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

