/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.FrameCaptureSettings;
import software.amazon.awssdk.services.mediaconvert.model.H264Settings;
import software.amazon.awssdk.services.mediaconvert.model.H265Settings;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2Settings;
import software.amazon.awssdk.services.mediaconvert.model.ProresSettings;
import software.amazon.awssdk.services.mediaconvert.model.VideoCodec;
import software.amazon.awssdk.services.mediaconvert.transform.VideoCodecSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoCodecSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, VideoCodecSettings> {
    private final String codec;
    private final FrameCaptureSettings frameCaptureSettings;
    private final H264Settings h264Settings;
    private final H265Settings h265Settings;
    private final Mpeg2Settings mpeg2Settings;
    private final ProresSettings proresSettings;

    private VideoCodecSettings(BuilderImpl builder) {
        this.codec = builder.codec;
        this.frameCaptureSettings = builder.frameCaptureSettings;
        this.h264Settings = builder.h264Settings;
        this.h265Settings = builder.h265Settings;
        this.mpeg2Settings = builder.mpeg2Settings;
        this.proresSettings = builder.proresSettings;
    }

    public VideoCodec codec() {
        return VideoCodec.fromValue(this.codec);
    }

    public String codecAsString() {
        return this.codec;
    }

    public FrameCaptureSettings frameCaptureSettings() {
        return this.frameCaptureSettings;
    }

    public H264Settings h264Settings() {
        return this.h264Settings;
    }

    public H265Settings h265Settings() {
        return this.h265Settings;
    }

    public Mpeg2Settings mpeg2Settings() {
        return this.mpeg2Settings;
    }

    public ProresSettings proresSettings() {
        return this.proresSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameCaptureSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.h264Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.h265Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpeg2Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.proresSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoCodecSettings)) {
            return false;
        }
        VideoCodecSettings other = (VideoCodecSettings)obj;
        return Objects.equals(this.codecAsString(), other.codecAsString()) && Objects.equals(this.frameCaptureSettings(), other.frameCaptureSettings()) && Objects.equals(this.h264Settings(), other.h264Settings()) && Objects.equals(this.h265Settings(), other.h265Settings()) && Objects.equals(this.mpeg2Settings(), other.mpeg2Settings()) && Objects.equals(this.proresSettings(), other.proresSettings());
    }

    public String toString() {
        return ToString.builder((String)"VideoCodecSettings").add("Codec", (Object)this.codecAsString()).add("FrameCaptureSettings", (Object)this.frameCaptureSettings()).add("H264Settings", (Object)this.h264Settings()).add("H265Settings", (Object)this.h265Settings()).add("Mpeg2Settings", (Object)this.mpeg2Settings()).add("ProresSettings", (Object)this.proresSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codecAsString()));
            }
            case "FrameCaptureSettings": {
                return Optional.ofNullable(clazz.cast(this.frameCaptureSettings()));
            }
            case "H264Settings": {
                return Optional.ofNullable(clazz.cast(this.h264Settings()));
            }
            case "H265Settings": {
                return Optional.ofNullable(clazz.cast(this.h265Settings()));
            }
            case "Mpeg2Settings": {
                return Optional.ofNullable(clazz.cast(this.mpeg2Settings()));
            }
            case "ProresSettings": {
                return Optional.ofNullable(clazz.cast(this.proresSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VideoCodecSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String codec;
        private FrameCaptureSettings frameCaptureSettings;
        private H264Settings h264Settings;
        private H265Settings h265Settings;
        private Mpeg2Settings mpeg2Settings;
        private ProresSettings proresSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoCodecSettings model) {
            this.codec(model.codec);
            this.frameCaptureSettings(model.frameCaptureSettings);
            this.h264Settings(model.h264Settings);
            this.h265Settings(model.h265Settings);
            this.mpeg2Settings(model.mpeg2Settings);
            this.proresSettings(model.proresSettings);
        }

        public final String getCodec() {
            return this.codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(VideoCodec codec) {
            this.codec(codec.toString());
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final FrameCaptureSettings.Builder getFrameCaptureSettings() {
            return this.frameCaptureSettings != null ? this.frameCaptureSettings.toBuilder() : null;
        }

        @Override
        public final Builder frameCaptureSettings(FrameCaptureSettings frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings;
            return this;
        }

        public final void setFrameCaptureSettings(FrameCaptureSettings.BuilderImpl frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings != null ? frameCaptureSettings.build() : null;
        }

        public final H264Settings.Builder getH264Settings() {
            return this.h264Settings != null ? this.h264Settings.toBuilder() : null;
        }

        @Override
        public final Builder h264Settings(H264Settings h264Settings) {
            this.h264Settings = h264Settings;
            return this;
        }

        public final void setH264Settings(H264Settings.BuilderImpl h264Settings) {
            this.h264Settings = h264Settings != null ? h264Settings.build() : null;
        }

        public final H265Settings.Builder getH265Settings() {
            return this.h265Settings != null ? this.h265Settings.toBuilder() : null;
        }

        @Override
        public final Builder h265Settings(H265Settings h265Settings) {
            this.h265Settings = h265Settings;
            return this;
        }

        public final void setH265Settings(H265Settings.BuilderImpl h265Settings) {
            this.h265Settings = h265Settings != null ? h265Settings.build() : null;
        }

        public final Mpeg2Settings.Builder getMpeg2Settings() {
            return this.mpeg2Settings != null ? this.mpeg2Settings.toBuilder() : null;
        }

        @Override
        public final Builder mpeg2Settings(Mpeg2Settings mpeg2Settings) {
            this.mpeg2Settings = mpeg2Settings;
            return this;
        }

        public final void setMpeg2Settings(Mpeg2Settings.BuilderImpl mpeg2Settings) {
            this.mpeg2Settings = mpeg2Settings != null ? mpeg2Settings.build() : null;
        }

        public final ProresSettings.Builder getProresSettings() {
            return this.proresSettings != null ? this.proresSettings.toBuilder() : null;
        }

        @Override
        public final Builder proresSettings(ProresSettings proresSettings) {
            this.proresSettings = proresSettings;
            return this;
        }

        public final void setProresSettings(ProresSettings.BuilderImpl proresSettings) {
            this.proresSettings = proresSettings != null ? proresSettings.build() : null;
        }

        public VideoCodecSettings build() {
            return new VideoCodecSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VideoCodecSettings> {
        public Builder codec(String var1);

        public Builder codec(VideoCodec var1);

        public Builder frameCaptureSettings(FrameCaptureSettings var1);

        default public Builder frameCaptureSettings(Consumer<FrameCaptureSettings.Builder> frameCaptureSettings) {
            return this.frameCaptureSettings((FrameCaptureSettings)((FrameCaptureSettings.Builder)FrameCaptureSettings.builder().applyMutation(frameCaptureSettings)).build());
        }

        public Builder h264Settings(H264Settings var1);

        default public Builder h264Settings(Consumer<H264Settings.Builder> h264Settings) {
            return this.h264Settings((H264Settings)((H264Settings.Builder)H264Settings.builder().applyMutation(h264Settings)).build());
        }

        public Builder h265Settings(H265Settings var1);

        default public Builder h265Settings(Consumer<H265Settings.Builder> h265Settings) {
            return this.h265Settings((H265Settings)((H265Settings.Builder)H265Settings.builder().applyMutation(h265Settings)).build());
        }

        public Builder mpeg2Settings(Mpeg2Settings var1);

        default public Builder mpeg2Settings(Consumer<Mpeg2Settings.Builder> mpeg2Settings) {
            return this.mpeg2Settings((Mpeg2Settings)((Mpeg2Settings.Builder)Mpeg2Settings.builder().applyMutation(mpeg2Settings)).build());
        }

        public Builder proresSettings(ProresSettings var1);

        default public Builder proresSettings(Consumer<ProresSettings.Builder> proresSettings) {
            return this.proresSettings((ProresSettings)((ProresSettings.Builder)ProresSettings.builder().applyMutation(proresSettings)).build());
        }
    }
}

