/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.transform.RectangleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rectangle
implements StructuredPojo,
ToCopyableBuilder<Builder, Rectangle> {
    private final Integer height;
    private final Integer width;
    private final Integer x;
    private final Integer y;

    private Rectangle(BuilderImpl builder) {
        this.height = builder.height;
        this.width = builder.width;
        this.x = builder.x;
        this.y = builder.y;
    }

    public Integer height() {
        return this.height;
    }

    public Integer width() {
        return this.width;
    }

    public Integer x() {
        return this.x;
    }

    public Integer y() {
        return this.y;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        hashCode = 31 * hashCode + Objects.hashCode(this.x());
        hashCode = 31 * hashCode + Objects.hashCode(this.y());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rectangle)) {
            return false;
        }
        Rectangle other = (Rectangle)obj;
        return Objects.equals(this.height(), other.height()) && Objects.equals(this.width(), other.width()) && Objects.equals(this.x(), other.x()) && Objects.equals(this.y(), other.y());
    }

    public String toString() {
        return ToString.builder((String)"Rectangle").add("Height", (Object)this.height()).add("Width", (Object)this.width()).add("X", (Object)this.x()).add("Y", (Object)this.y()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
            case "X": {
                return Optional.ofNullable(clazz.cast(this.x()));
            }
            case "Y": {
                return Optional.ofNullable(clazz.cast(this.y()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RectangleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer height;
        private Integer width;
        private Integer x;
        private Integer y;

        private BuilderImpl() {
        }

        private BuilderImpl(Rectangle model) {
            this.height(model.height);
            this.width(model.width);
            this.x(model.x);
            this.y(model.y);
        }

        public final Integer getHeight() {
            return this.height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        public final Integer getWidth() {
            return this.width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        public final Integer getX() {
            return this.x;
        }

        @Override
        public final Builder x(Integer x) {
            this.x = x;
            return this;
        }

        public final void setX(Integer x) {
            this.x = x;
        }

        public final Integer getY() {
            return this.y;
        }

        @Override
        public final Builder y(Integer y) {
            this.y = y;
            return this;
        }

        public final void setY(Integer y) {
            this.y = y;
        }

        public Rectangle build() {
            return new Rectangle(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Rectangle> {
        public Builder height(Integer var1);

        public Builder width(Integer var1);

        public Builder x(Integer var1);

        public Builder y(Integer var1);
    }
}

