/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.PresetSettings;
import software.amazon.awssdk.services.mediaconvert.model.Type;
import software.amazon.awssdk.services.mediaconvert.transform.PresetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Preset
implements StructuredPojo,
ToCopyableBuilder<Builder, Preset> {
    private final String arn;
    private final String category;
    private final Instant createdAt;
    private final String description;
    private final Instant lastUpdated;
    private final String name;
    private final PresetSettings settings;
    private final String type;

    private Preset(BuilderImpl builder) {
        this.arn = builder.arn;
        this.category = builder.category;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastUpdated = builder.lastUpdated;
        this.name = builder.name;
        this.settings = builder.settings;
        this.type = builder.type;
    }

    public String arn() {
        return this.arn;
    }

    public String category() {
        return this.category;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String description() {
        return this.description;
    }

    public Instant lastUpdated() {
        return this.lastUpdated;
    }

    public String name() {
        return this.name;
    }

    public PresetSettings settings() {
        return this.settings;
    }

    public Type type() {
        return Type.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Preset)) {
            return false;
        }
        Preset other = (Preset)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Preset").add("Arn", (Object)this.arn()).add("Category", (Object)this.category()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("LastUpdated", (Object)this.lastUpdated()).add("Name", (Object)this.name()).add("Settings", (Object)this.settings()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PresetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String category;
        private Instant createdAt;
        private String description;
        private Instant lastUpdated;
        private String name;
        private PresetSettings settings;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Preset model) {
            this.arn(model.arn);
            this.category(model.category);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.lastUpdated(model.lastUpdated);
            this.name(model.name);
            this.settings(model.settings);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final PresetSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(PresetSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(PresetSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public Preset build() {
            return new Preset(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Preset> {
        public Builder arn(String var1);

        public Builder category(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder lastUpdated(Instant var1);

        public Builder name(String var1);

        public Builder settings(PresetSettings var1);

        default public Builder settings(Consumer<PresetSettings.Builder> settings) {
            return this.settings((PresetSettings)((PresetSettings.Builder)PresetSettings.builder().applyMutation(settings)).build());
        }

        public Builder type(String var1);

        public Builder type(Type var1);
    }
}

